
function IniciarLoteria() {
    return {
        loading: false,
        cartas: [],
        cartones: [],
        miCarton: { cartas: [] },
        search: '',
        get cartasFiltradas() {
            if (this.search === "") {
                return this.cartas;
            }
            return this.cartas.filter((c) => {
                return c.name
                    .toLowerCase()
                    .includes(this.search.toLowerCase());
            });
        },
        async loadData() {
            this.loading = true;
            try {
                data = await (await fetch('./data/loteria.json')).json()
                //this.cartas = data.cartasNavida.map(c => ({ ...c, selecionada: false }));
                this.cartas = data.cartasDic2023.map(c => ({ ...c, selecionada: false }));
                this.cartones = data.cartonesDic2023.map(c => ({ ...c, cartas: c.cartas.map(mc => this.cartas.find(fc => fc.id == mc)) }));
            } catch (error) {

            }
            this.loading = false;
        },
        getCountSelected(carton) {
            return "Marcadas: " + carton.cartas.filter(carta => carta.selecionada).length
        },
        getTextLoteria(carton) {
            return (carton.cartas.filter(carta => carta.selecionada).length == carton.cartas.length ? 'Lotería' : 'Aún falta')
        },
        loteria(carton) {
            return carton.cartas.filter(carta => carta.selecionada).length == carton.cartas.length
        },
        setMiCarton(carton) {
            this.miCarton = carton
        }
    }
}